'use strict';

angular.module('genisis').controller('requestsCtrl', ['$scope', 'request',
  '$location', 'user', '$rootScope', 'api', 'type', 'focus', '$window',
  function (
    $scope,
    $requests,
    $location,
    $user,
    $rootScope,
    $api,
    $type,
    $focus,
    $window) {

    $scope.requestService = $requests;
    $scope.requestFilter = '';
    $scope.orderBy = '-id';
    $scope.requests = [];
    $scope.type = $type;
    $scope.allowedToCreate = true;
    $scope.requestService = $requests;
    $scope.loading = 'Requests are loading...';
    $scope.sortStatus = 'Sorted by ID descending';
    // Check if user can create request or access this page
    if (!$user.allowedToAccess('createRequest')) {
      // redirect back to requests page
      $scope.allowedToCreate = false;
    }

    if ($user.requester()) {
      $location.path('/myRequests');
    }

    /**
     * Figure out what requests should be loaded for the user depending on their
     * current user permissions
     * @param string permission the user's permission level
     * @return object the configuration needed for the API call
     **/
    $scope.requestsConfig = function (permissions) {
      var config = {
        value: $user.username(),
        context: 'createdBy'
      };

      switch (permissions) {
        //see all of their requests and the submitted one they're manager for
      case 'Genisis2 Manager':
        config = {
          value: $user.username(),
          context: 'dataManager'
        };
        break;
        //see all requests
      case 'VINCI Manager':
        config = {
          value: $user.username(),
          context: 'dataSourceManager'
        };
        break;
      case 'Administrator':
        config = {
          value: null,
          context: null
        };
        break;
      }

      return config;
    };

    //load their requests
    if ($user.Administrator()) {
      $api.retrieve('requests', {})
        .then(function (data) {
          if (data.response.length > 0) {
            $scope.requests = data.response;
          } else {
            $scope.requests = [];
            $scope.loading = 'No Requests found';
          }
        });
    } else {
      $requests.load($scope.requestsConfig($user.permissions()))
        .then(function (data) {
          if (data.length > 0) {
            $scope.requests = data;
          } else {
            $scope.requests = [];
            $scope.loading = 'No Requests found';
          }
        });
    }

    $scope.focusTable = function () {
      $focus('table');
    };

    /**
     * Trying to create a new request, redirect to the create request page
     **/
    $scope.createRequest = function () {
      $location.path('/requestType');
      return true;
    };

    /**
     * Trying to edit a request
     * @param int id the request id
     * @param boolean
     **/
    $scope.editRequest = function (id) {
      //make sure they have an ID and the request exists
      if (id && parseInt(id, 10)) {
        $location.path('/requests/' + id);
        return true;
      }

      return false;
    };

    /**
     * Checking to see whether or not they can edit a request
     *
     * @param string the status of the request
     * @return boolean
     **/
    $scope.copyRequestAble = $scope.requestService.canCopyRequest;
    $scope.canEdit = function (request) {
      if (request) {
        switch (request.statusDescription) {
        case 'Draft':
        case 'Returned':
          if (request.createdBy === $user.username() || $user.Administrator()) {
            return true;
          } else {
            return false;
          }
          break;
        case null:
          return true;
        }

        return false;
      } else {
        return false;
      }
    };

    /**
     * Checking to see whether or not they can manage this request
     *
     * @param string the status of the request
     * @return boolean
     **/
    $scope.canManage = function (status) {
      switch (status) {
      case 'Submitted':
        if ($user.genisis2Mgr() || $user.Administrator()) {
          return true;
        }
      }

      return false;
    };



    $scope.canReturnToDDM = $requests.canReturnToDDM;
    /**
     * Checking to see whether or not they can approve or deny the data
     *
     * @param string the status of the request
     * @return boolean
     **/
    $scope.canData = function (status) {
      switch (status) {
      case 'Sent':
        if ($user.vinciMgr() || $user.Administrator()) {
          return true;
        }
      }

      return false;
    };

    $scope.canDeliver = function (request) {
      if (request.requestTypeId === 1) {
        switch (request.statusDescription) {
        case 'RequestAccepted':
          if ($user.vinciMgr() || $user.Administrator()) {
            return true;
          }
        }
      } else {
        switch (request.statusDescription) {
        case 'RequestAccepted':
          if ($user.genisis2Mgr() || $user.Administrator()) {
            return true;
          }
        }
      }

      return false;
    };

    /**
     * Checking to see whether or not they can approve or deny the data
     *
     * @param string the status of the request
     * @return boolean
     **/
    $scope.canResults = function (request) {
      if (request.statusDescription === 'ResultsDelivered') {
        if (request.requestTypeId === 1) {
          if ($user.genisis2Mgr() || $user.Administrator()) {
            return true;
          }
        } else {
          if ($user.vinciMgr() || $user.Administrator()) {
            return true;
          }
        }
      }
      return false;
    };

    $scope.cancelRequest = function (req) {
      //cleaer any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      $requests.mustComment(req);
    };

    $scope.returnToDDM = function (req) {
      $rootScope.errors = [];
      $rootScope.messages = [];
      $requests.mustComment(req);
    };

    /**
     * Submitting a request to the data manager
     * @param Object request data
     * @return boolean
     **/
    $scope.submitRequest = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if (!$requests.valid(req)) {
        return false;
      }

      return $api.update('requests/' + req.id + '/submit', {
        data: {
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {

          req.statusDescription = 'Submitted';

          //set a message that the request was submitted
          // $rootScope.messages.push(
          //   'Your request has been submitted to your data manager.'
          // );
          $window.alert(
            'Your request has been submitted to your data manager.'
          );

          return true;
        } else {
          // $rootScope.errors.push('Submit request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow data managers to accept data from the data supplier
     * @param Object request the request that's data is being accepted
     * @return boolean
     **/
    $scope.requestTypes = function () {
      return $api.retrieve('requestTypes/', {})
        .then(function (requestType) {
          if (requestType.success && requestType.response) {
            if (requestType.response instanceof Array) {
              $scope.requestTypes = requestType.response;
            } else {
              $scope.requestTypes = [requestType.response];
            }
          } else {
            $window.alert(requestType.message);
          }
        });
    };
    $scope.acceptData = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      return $api.update('requests/' + req.id + '/acceptdata', {
        data: {
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request\'s data has been accepted.');
          $window.alert(
            'This request\'s data has been accepted.');

          req.statusDescription = 'RequestAccepted';
          return true;
        } else {
          // $rootScope.errors.push(
          //   'Accept data request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow data managers to reject data from the data supplier
     * @param Object request the request that's data is being accepted
     * @return boolean
     **/
    $scope.denyData = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      $requests.mustComment(req);

      // return $api.update('requests/' + req.id + '/denydata', {
      //   data: {
      //     createdBy: $user.id()
      //   }
      // }).then(function (request) {

      //   if (request.success && request.response) {
      //     // $rootScope.messages.push(
      //     //   'This request has been denied because the ' +
      //     //   'request cannot be fulfilled.');

      //     // $window.alert(
      //     //   'This request has been denied because the ' +
      //     //   'request cannot be fulfilled.');

      //     $requests.mustComment(request);

      //     req.statusDescription = 'RequestNotAccepted';
      //     return true;
      //   } else {
      //     // $rootScope.errors.push('Deny data request API call failed.');
      //     $api.errorAlert();
      //   }

      //   return false;
      // });
    };

    $scope.deliverResults = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      $requests.mustComment(req);

      // return $api.update('requests/' + req.id + '/resultsdelivered', {
      //   data: {
      //     createdBy: $user.id()
      //   }
      // }).then(function (request) {
      //   if (request.success && request.response) {
      //     // $window.alert(
      //     //   'Results are delivered.'
      //     // );

      //     $requests.mustComment(request);

      //     req.statusDescription = 'ResultsDelivered';

      //     return true;
      //   } else {
      //     // $rootScope.errors.push(
      //     //   'Deliver results request API call failed.');
      //     $api.errorAlert();
      //   }

      //   return false;
      // });
    };

    /**
     * Allow researcher to accept data from the data supplier
     * @param Object request the request that's data is being confirmed for
     * @return boolean
     **/
    $scope.acceptResults = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      return $api.update('requests/' + req.id + '/confirmdata', {
        data: {
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request\'s data has been accepted.'
          // );
          $window.alert(
            'This request\'s data has been accepted.'
          );
          req.statusDescription = 'ResultsAccepted';
          return true;
        } else {
          // $rootScope.errors.push(
          //   'Accept results request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow researcher to reject the data from the data supplier
     * @param Object request the request that's data is being rejected for
     * @return boolean
     **/
    $scope.denyResults = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      $requests.mustComment(req);

      // return $api.update('requests/' + req.id + '/rejectdata', {
      //   data: {
      //     createdBy: $user.id()
      //   }
      // }).then(function (request) {

      //   if (request.success && request.response) {
      //     // $rootScope.messages.push(
      //     //   'This request\'s data has been rejected by the data manager.'
      //     // );

      //     // $window.alert(
      //     //   'This request\'s data has been rejected by the data manager.'
      //     // );



      //     req.statusDescription = 'ResultsNotAccepted';
      //     return true;
      //   } else {
      //     // $rootScope.errors.push(
      //     //   'Deny results request API call failed.');
      //     $api.errorAlert();
      //   }

      //   return false;
      // });
    };
    $scope.requestTypes();
  }
]);